/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Attribute;
import com.techtrader.modules.tools.bytecode.lowlevel.ConstantPool;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import com.techtrader.modules.tools.bytecode.visitor.VisitAcceptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class BCEntity
implements VisitAcceptor {
    private List _attributes = new LinkedList();

    public abstract ConstantPool getPool();

    public Attribute[] getAttributes() {
        return this._attributes.toArray(new Attribute[this._attributes.size()]);
    }

    public Attribute getAttribute(String string) {
        Iterator iterator = this._attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public Attribute[] getAttributes(String string) {
        LinkedList<Attribute> linkedList = new LinkedList<Attribute>();
        Iterator iterator = this._attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(string)) continue;
            linkedList.add(attribute);
        }
        return linkedList.toArray(new Attribute[linkedList.size()]);
    }

    public Attribute importAttribute(Attribute attribute) {
        Attribute attribute2 = this.addAttribute(attribute.getName());
        attribute2.copy(attribute);
        return attribute2;
    }

    public void importAttributes(BCEntity bCEntity) {
        Attribute[] attributeArray = bCEntity.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            this.importAttribute(attributeArray[n]);
            ++n;
        }
    }

    public Attribute addAttribute(String string) {
        Attribute attribute = Attribute.createAttribute(string, this);
        this._attributes.add(attribute);
        return attribute;
    }

    public void clearAttributes() {
        this._attributes.clear();
    }

    public boolean removeAttribute(String string) {
        Attribute[] attributeArray = this.getAttributes(string);
        int n = 0;
        while (n < attributeArray.length) {
            this.removeAttribute(attributeArray[n]);
            ++n;
        }
        return attributeArray.length > 0;
    }

    public boolean removeAttribute(Attribute attribute) {
        if (attribute == null || !this._attributes.remove(attribute)) {
            return false;
        }
        attribute.invalidate();
        return true;
    }

    protected void readAttributes(DataInput dataInput) throws IOException {
        this._attributes.clear();
        int n = dataInput.readUnsignedShort();
        while (n > 0) {
            String string = this.getPool().getUTF(dataInput.readUnsignedShort());
            Attribute attribute = this.addAttribute(string);
            attribute.readData(dataInput, dataInput.readInt());
            --n;
        }
    }

    protected void writeAttributes(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._attributes.size());
        Iterator iterator = this._attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            dataOutput.writeShort(attribute.getNameIndex());
            int n = attribute.getLength();
            dataOutput.writeInt(n);
            attribute.writeData(dataOutput, n);
        }
    }

    public void visitAttributes(BCVisitor bCVisitor) {
        Iterator iterator = this._attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            bCVisitor.enterAttribute(attribute);
            attribute.acceptVisit(bCVisitor);
            bCVisitor.exitAttribute(attribute);
        }
    }

    public abstract void acceptVisit(BCVisitor var1);
}

